# 画面設計書 1-Simply VB Unit Runner

## 概要

本ドキュメントは、VBCorLibプロジェクトのユニットテスト実行画面「Simply VB Unit Runner」の画面設計書です。

### 本画面の処理概要

Simply VB Unit RunnerはVBCorLibライブラリの品質保証を目的としたユニットテスト実行画面です。SimplyVBUnit.Component.ocxを使用して、VBCorLibに含まれる各種クラス・機能のテストスイートを実行し、テスト結果を視覚的に表示します。

**業務上の目的・背景**：VBCorLibは.NET Frameworkの機能をVB6/VBAに移植したライブラリであり、多数の複雑な機能（配列操作、文字列処理、暗号化、IO操作等）を提供しています。これらの機能が正しく動作することを保証するため、包括的なユニットテスト基盤が必要です。本画面は開発者がテストスイートを一括実行し、即座に結果を確認できる環境を提供することで、継続的な品質保証と回帰テストを可能にします。

**画面へのアクセス方法**：VBCorLibテストプロジェクト（Source/Tests/VBCorLibTests.vbp）を開き、F5キーで実行することでこの画面が表示されます。

**主要な操作・処理内容**：
1. フォームロード時にテストスイートを自動読み込み（System、Collections、Cryptography、IO等のカテゴリ別）
2. F5キー押下でテストスイート全体を実行
3. ESCキー押下で画面を終了
4. UIRunnerコントロールによるテスト進捗・結果の表示

**画面遷移**：本画面は独立したテストランナーであり、他の画面への遷移はありません。VB IDEから直接起動し、ESCキーで終了します。

**権限による表示制御**：本画面は開発者向けテストツールであり、特別な権限制御は実装されていません。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 1 | CorArray | 主機能 | テストスイート内の配列操作テスト（CorArrayTests、CorArrayCopyTests、CorArraySortTests等）の実行 |
| 2 | CorString | 主機能 | テストスイート内の文字列処理テスト（CorStringTests）の実行 |
| 3 | CorDateTime | 主機能 | テストスイート内の日付時刻テスト（CorDateTimeTests）の実行 |
| 4 | TimeSpan | 主機能 | テストスイート内の時間間隔テスト（TimeSpanTests）の実行 |
| 5 | TimeZone | 主機能 | テストスイート内のタイムゾーンテスト（TimeZoneTests）の実行 |
| 6 | Guid | 主機能 | テストスイート内のGUIDテスト（GuidTests）の実行 |
| 7 | Version | 主機能 | テストスイート内のバージョンテスト（VersionTests）の実行 |
| 8 | Environment | 主機能 | テストスイート内の環境情報テスト（EnvironmentTests）の実行 |
| 9 | OperatingSystem | 主機能 | テストスイート内のOS情報テスト（OperatingSystemTests）の実行 |
| 11 | Random | 主機能 | テストスイート内の乱数生成テスト（RandomTests）の実行 |
| 12 | BitConverter | 主機能 | テストスイート内のビット変換テスト（BitConverterTests）の実行 |
| 13 | Convert | 主機能 | テストスイート内の型変換テスト（ConvertTests、ConvertToBase64Tests、ConvertFromBase64Tests）の実行 |
| 14 | CorMath | 主機能 | テストスイート内の数学関数テスト（CorMathTests）の実行 |
| 15 | Buffer | 主機能 | テストスイート内のバッファテスト（BufferTests）の実行 |
| 16 | Char | 主機能 | テストスイート内の文字テスト（CharTests、CharEnumeratorTests）の実行 |
| 17 | StringBuilder | 主機能 | テストスイート内のStringBuilderテスト（StringBuilderTests）の実行 |
| 18 | ArrayList | 主機能 | テストスイート内のArrayListテスト（ArrayListTests等）の実行 |
| 19 | Stack | 主機能 | テストスイート内のStackテスト（StackTests、StackEnumeratorTests）の実行 |
| 20 | Queue | 主機能 | テストスイート内のQueueテスト（QueueTests、QueueEnumeratorTests）の実行 |
| 21 | Hashtable | 主機能 | テストスイート内のHashtableテスト（HashtableTests等）の実行 |
| 22 | SortedList | 主機能 | テストスイート内のSortedListテスト（SortedListTests等）の実行 |
| 23 | BitArray | 主機能 | テストスイート内のBitArrayテスト（BitArrayTests、BitArrayEnumeratorTests）の実行 |
| 24 | Comparer | 主機能 | テストスイート内のComparerテスト（ComparerTests、CaseInsensitiveComparerTests）の実行 |
| 49 | RijndaelManaged | 主機能 | テストスイート内のRijndaelテスト（RijndaelManagedTests、RijndaelTests）の実行 |
| 50 | DESCryptoServiceProvider | 主機能 | テストスイート内のDESテスト（DESCryptoServiceProviderTests等）の実行 |
| 51 | TripleDESCryptoServiceProvider | 主機能 | テストスイート内のTripleDESテスト（TripleDESCryptoServiceProviderTests等）の実行 |
| 52 | RC2CryptoServiceProvider | 主機能 | テストスイート内のRC2テスト（RC2CryptoServiceProviderTests等）の実行 |
| 53 | RSACryptoServiceProvider | 主機能 | テストスイート内のRSAテスト（RSACryptoServiceProviderTests）の実行 |
| 54 | DSACryptoServiceProvider | 主機能 | テストスイート内のDSAテスト（DSACryptoServiceProviderTests）の実行 |
| 55 | SHA1Managed | 主機能 | テストスイート内のSHA1テスト（SHA1CryptoServiceProviderTests、SHA1ManagedTests）の実行 |
| 56 | SHA256Managed | 主機能 | テストスイート内のSHA256テスト（SHA256ManagedTests）の実行 |
| 57 | SHA384Managed | 主機能 | テストスイート内のSHA384テスト（SHA384ManagedTests）の実行 |
| 58 | SHA512Managed | 主機能 | テストスイート内のSHA512テスト（SHA512ManagedTests）の実行 |
| 59 | MD5CryptoServiceProvider | 主機能 | テストスイート内のMD5テスト（MD5CryptoServiceProviderTests）の実行 |
| 60 | RIPEMD160Managed | 主機能 | テストスイート内のRIPEMD160テスト（RIPEMD160ManagedTests）の実行 |
| 68 | RNGCryptoServiceProvider | 主機能 | テストスイート内の暗号乱数テスト（RNGCryptoServiceProviderTests）の実行 |
| 69 | Rfc2898DeriveBytes | 主機能 | テストスイート内のPBKDF2テスト（Rfc2898DeriveBytesTests）の実行 |
| 70 | CryptoStream | 主機能 | テストスイート内のCryptoStreamテスト（CryptoStreamTests）の実行 |
| 84 | BigInteger | 主機能 | テストスイート内のBigIntegerテスト（BigIntegerTests等）の実行 |
| 85 | ResourceManager | 主機能 | テストスイート内のResourceManagerテスト（ResourceManagerTests）の実行 |
| 90 | Registry | 主機能 | テストスイート内のRegistryテスト（RegistryTests）の実行 |
| 91 | RegistryKey | 主機能 | テストスイート内のRegistryKeyテスト（RegistryKeyTests）の実行 |
| 95 | MemoryMappedFile | 主機能 | テストスイート内のMemoryMappedFileテスト（MemoryMappedFileTests）の実行 |

## 画面種別

テスト実行・結果表示

## URL/ルーティング

VB6デスクトップアプリケーションのため、URLルーティングは存在しません。フォームファイル: `Source/Tests/frmSimplyVBUnitRunner.frm`

## 入出力項目

本画面はテスト実行結果の表示専用であり、ユーザーからの直接的な入力項目はありません。

| 項目名 | 項目種別 | 説明 |
|--------|----------|------|
| UIRunner1 | 出力 | SimplyVBUnit.Component.ocxのUIRunnerコントロール。テスト結果を表示 |

## 表示項目

| 項目名 | データ型 | 説明 |
|--------|----------|------|
| テストスイート一覧 | TreeView | カテゴリ別に構造化されたテストケース一覧 |
| テスト実行結果 | 各種 | 成功/失敗数、実行時間、エラー詳細 |

## イベント仕様

### 1-Form_Load

フォーム読み込み時にテストスイートを初期化します。

**処理内容**:
1. SkipUnsupportedTimeZone フラグをFalseに設定
2. 以下のテストスイートを順次追加:
   - Microsoft.Win32（Registry関連）
   - System（基本型、例外、配列、文字列等）
   - System.Collections（ArrayList、Hashtable、Stack、Queue等）
   - System.Security.Cryptography（暗号化アルゴリズム全般）
   - System.Resources（リソース管理）
   - System.IO（ファイルIO）
   - System.IO.MemoryMappedFiles（メモリマップトファイル）
   - System.Text（エンコーディング、StringBuilder）
   - System.Globalization（カレンダー、カルチャー）
   - System.Numerics（BigInteger）
   - System.Security（セキュリティ要素）
   - System.Diagnostics（StopWatch）

### 2-Form_Initialize

フォーム初期化時にUIRunnerを設定します。

**処理内容**:
1. UIRunner1.Init Appでアプリケーション情報を渡す
2. OutputLoggerリスナーを追加してテスト出力をロギング

### 3-Form_KeyDown

キーボード入力を処理します。

**処理内容**:
| キー | アクション |
|------|----------|
| ESC (vbKeyEscape) | フォームをアンロードして終了 |
| F5 (vbKeyF5) | UIRunner1.Runでテスト実行 |

## データベース更新仕様

本画面はデータベースを使用しません。テストはメモリ上で実行され、結果は画面に表示されるのみです。

## メッセージ仕様

| メッセージID | メッセージ内容 | 表示条件 |
|-------------|---------------|----------|
| - | テスト結果はUIRunnerコントロール内に表示 | テスト実行完了時 |

## 例外処理

| 例外種別 | 対処方法 |
|---------|---------|
| テストケース実行エラー | UIRunnerがエラーをキャッチし、失敗としてカウント・表示 |
| テストスイート追加エラー | 該当スイートがスキップされる |

## 備考

- SimplyVBUnit.Component.ocxが必要です（外部コンポーネント）
- OutputLoggerクラスによりテスト出力がファイルに記録される場合があります
- SkipUnsupportedTimeZoneフラグにより、環境依存のタイムゾーンテストをスキップ可能

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

テストスイートは階層構造で構成されています。Sim.NewTestSuiteでカテゴリを作成し、.Addでテストクラスを追加します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | frmSimplyVBUnitRunner.frm | `Source/Tests/frmSimplyVBUnitRunner.frm` | テストスイートの階層構造とカテゴリ分け |

**読解のコツ**: VB6のWithステートメントを使用したオブジェクト操作パターンに注目してください。Sim.NewTestSuite()はSimplyVBUnitライブラリが提供するファクトリ関数です。

#### Step 2: エントリーポイントを理解する

フォーム読み込み時の初期化処理がエントリーポイントです。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | frmSimplyVBUnitRunner.frm | `Source/Tests/frmSimplyVBUnitRunner.frm` | Form_Load, Form_Initializeの処理順序 |

**主要処理フロー**:
1. **行55-70 (Form_Load)**: テストスイートの登録。AddSystem、AddSystemCollections等の各カテゴリ追加メソッドを呼び出し
2. **行398-401 (Form_Initialize)**: UIRunnerの初期化とリスナー追加
3. **行403-410 (Form_KeyDown)**: キー入力によるテスト実行/終了制御

#### Step 3: テストスイート追加処理を理解する

各カテゴリのテストスイート追加処理を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | frmSimplyVBUnitRunner.frm | `Source/Tests/frmSimplyVBUnitRunner.frm` | 行88-148 AddSystemメソッド - 基本システムテストの追加 |
| 3-2 | frmSimplyVBUnitRunner.frm | `Source/Tests/frmSimplyVBUnitRunner.frm` | 行150-189 AddSystemCollectionsメソッド - コレクションテストの追加 |
| 3-3 | frmSimplyVBUnitRunner.frm | `Source/Tests/frmSimplyVBUnitRunner.frm` | 行191-245 AddSystemSecurityCryptographyメソッド - 暗号化テストの追加 |

**主要処理フロー**:
- **行386-396 (NewSuite)**: ヘルパー関数。名前付きテストスイートを作成しFixturesを追加

### プログラム呼び出し階層図

```
Form_Initialize
    │
    ├─ UIRunner1.Init App
    │
    └─ UIRunner1.AddListener(OutputLogger)

Form_Load
    │
    ├─ AddMicrosoftWin32
    │      └─ Sim.NewTestSuite("Microsoft.Win32")
    │             └─ .Add [テストクラス群]
    │
    ├─ AddSystem
    │      └─ Sim.NewTestSuite("System")
    │             └─ .Add [テストクラス群]
    │                    └─ NewSuite (サブスイート作成)
    │
    ├─ AddSystemCollections
    ├─ AddSystemSecurityCryptography
    ├─ AddSystemResources
    ├─ AddSystemIO
    ├─ AddSystemIOMemoryMappedFiles
    ├─ AddSystemText
    ├─ AddSystemGlobalization
    ├─ AddSystemNumerics
    ├─ AddSystemSecurity
    └─ AddSystemDiagnostics

Form_KeyDown
    │
    ├─[F5] UIRunner1.Run
    │
    └─[ESC] Unload Me
```

### データフロー図

```
[入力]               [処理]                    [出力]

テストクラス群 ───▶ Sim.NewTestSuite ───▶ テストスイート階層
                          │
                          ▼
                     AddTest .This
                          │
                          ▼
F5キー押下 ────────▶ UIRunner1.Run ────▶ テスト実行結果表示
                          │
                          ▼
                   OutputLogger ────────▶ ログファイル(任意)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| frmSimplyVBUnitRunner.frm | `Source/Tests/frmSimplyVBUnitRunner.frm` | ソース | メインフォーム |
| frmSimplyVBUnitRunner.frx | `Source/Tests/frmSimplyVBUnitRunner.frx` | バイナリ | フォームアイコンリソース |
| VBCorLibTests.vbp | `Source/Tests/VBCorLibTests.vbp` | プロジェクト | テストプロジェクト定義 |
| OutputLogger.cls | `Source/Tests/OutputLogger.cls` | ソース | テスト出力ロガー |
| SimplyVBUnit.Component.ocx | 外部 | OCX | テスト実行エンジン |
| *Tests.cls | `Source/Tests/` | ソース | 各種テストクラス（多数） |
